// Copyright (C) 2020 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only

#include "qwaylandcompositoriviapplicationforeign_p.h"

QT_BEGIN_NAMESPACE

/*!
    \qmlmodule QtWayland.Compositor.IviApplication
    \title Qt Wayland IviApplication Extension
    \ingroup qmlmodules
    \brief Provides a Qt API for the IviApplication shell extension.

    \section2 Summary
    IviApplication is a shell extension suitable for lightweight compositors,
    for example in In-Vehicle Infotainment (IVI) systems.

    IviApplication corresponds to the Wayland \c ivi_application interface.

    \section2 Usage
    To use this module, import it like this:
    \code
    import QtWayland.Compositor.IviApplication
    \endcode
*/

QT_END_NAMESPACE

#include "moc_qwaylandcompositoriviapplicationforeign_p.cpp"
