// Copyright (C) 2025 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
// Qt-Security score:significant reason:default

#ifndef QQSTYLEKITTHEME_P_H
#define QQSTYLEKITTHEME_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <QtQml/QtQml>

#include "qqstylekitcontrols_p.h"
#include "qqstylekitpalette_p.h"

QT_BEGIN_NAMESPACE

class QQStyleKitControls;
class QQStyleKitPropertyResolver;

class QQStyleKitTheme : public QQStyleKitControls
{
    Q_OBJECT

    Q_PROPERTY(QQStyleKitPalette *palettes READ palettes NOTIFY palettesChanged FINAL)

    QML_NAMED_ELEMENT(Theme)

public:
    QQStyleKitTheme(QObject *parent = nullptr);

    QQStyleKitStyle *style() const;
    QQStyleKitPalette *palettes();

signals:
    void targetChanged();
    void palettesChanged();

protected:
    void componentComplete() override;

private:
    Q_DISABLE_COPY(QQStyleKitTheme)

    bool m_completed = false;
    QQStyleKitPalette m_palettes;

    void updateThemePalette();
    void updateQuickTheme();

    friend class QQStyleKitAttached;
    friend class QQStyleKitStyle;
};

QT_END_NAMESPACE

#endif // QQSTYLEKITTHEME_P_H
